def input_validation (x,y):
  #check if input is an integer
  try:
    val = x
  except ValueError:
    print("Invalid input. Try again.")
    return False 

  if val in y:
    return True
  else:
    print("Invalid input. Try again.")
    return False

#Each is_input_valid make it to where we can use the function in each input variable section. Once it was set to true we had a problem where it would skip over every other section.
is_input_valid_0 = False #initialize the variable that can break the loop
is_input_valid_1 = False

is_input_valid_2 = False

is_input_valid_3 = False

is_input_valid_4 = False

#These are all the dictionaries we use so that we can search the function with the input of a matching integer. This reduces typing of the user and makes the code more efficient overall. 
#major dictionary 
MandMsheet1 = {
  "0": "Early Childhood Education",
  "1": "Elementary Education",
  "2": "Music Education",
  "3": "Science Education",
  "4": "Health Education",
  "5": "Journalism Education",
  "6": "English Education",
  "7": "Math Education",
  "8": "Social Studies Education",
  "9": "Theatre",
  "10": "Teaching All Learners",
  "11": "Secondary Special Education",
  "12": "Visual Arts Education",
  "13": "World Languages Education"
}

#gender scholarships dictionary
G_Scholarships = {
  "0": "Male",
  "1": "Female",
  "2": "Transgendered",
  "3": "Non-Binary",
  "4": "Gender Fluid",
  "5": "Other"
}

#first generation scholarships dictionary 
Gen_Scholarships = {
  "0": "Yes",
  "1": "No"
}

#race scholarships dictionary
R_E_Scholarships = {
  "0": "Hispanic/Latinx",
  "1": "African American",
  "2": "Asian",
  "3": "Indigenous",
  "4": "Pacific Islander",
  "5": "Middle Eastern",
  "6": "Two or More Races",
  "7": "White",
  "8": "Other"
}

#sexuality scholarships dictionary
S_Scholarships = {
  "0": "Heterosexual",
  "1": "Gay",
  "2": "Lesbian",
  "3": "Bisexual",
  "4": "Queer",
  "5": "Asexual",
  "6": "Pansexual",
  "7": "Other"
}

#welcome message
print("Welcome to the Indiana University School of Education! \nWe're so glad to have you!\nUse this program to learn about minors, clubs, electives, and scholarships that might be a good fit for you!")
#name input
name = input("\nWhat is your name?: ")
#age input, checks for integer
while True:
  try: age=int(input ("\nHow old are you?: "))
  except Exception:
    print("You must enter a number")
    continue
  else: 
    break
#major input 
while is_input_valid_0 == False:
  major= input("\nWhat is your major? Choose from the following options and enter the number corresponding with the major: \n0: Early Childhood Education\n1: Elementary Education\n2: Music Education\n3: Science Education\n4: Health Education\n5: Journalism Eduation\n6: English Education\n7: Math Education\n8: Social Studies Education\n9: Theatre Education\n10: Teaching All Learners\n11: Secondary Special Education\n12: Visual Arts Education\n13: World Languages Education \n") 
  is_input_valid_0 = input_validation(major, MandMsheet1)
#gender input
while is_input_valid_1 == False:
  gender = input("\nWhat is your gender? Choose from the following options:\n0: Male\n1: Female\n2: Transgenered\n3: Non-Binary\n4: Gender Fluid\n5: Other\n").lower()
  is_input_valid_1 = input_validation(gender, G_Scholarships)
#race/ethnicity input
while is_input_valid_2 == False:
  race= input ("\nWhat is your race/ethnicity? Choose from the following options:\n0: Hispanic/Latinx\n1: African American\n2: Asian\n3: Indigenous\n4: Pacific Islander\n5: Middle Eastern\n6: Two or More Races\n7: White\n8: Other\n") .lower()
  is_input_valid_2 = input_validation(race, R_E_Scholarships)

#sexuality input
while is_input_valid_3 == False:
  sexuality = input ("\nWhat is your sexuality? Choose from the following options: \n0: Heterosexual\n1: Gay\n2: Lesbian\n3: Bisexual\n4: Queer\n5: Asexual\n6: Pansexual\n7: Other\n").lower()
  is_input_valid_3 = input_validation(sexuality, S_Scholarships)
  
#first gen input
while is_input_valid_4 == False:
  first_gen = input ("\nAre you a first generation college student? \nAnswer 0 for yes or 1 for no: ").lower()
  is_input_valid_4 = input_validation(first_gen, Gen_Scholarships)

print ("\nName: ",name,)

print ("\nAge: ",age,)
#Our program is heavily influenced by a set of data that we created in google sheets. By creating this data in such a way we are able to port it as a csv or comma seperated value file. These types of files are closely related to python as it is a primary way in which we can important and export information as a group of dictionary. The CSV files are named according to whatever they are identifying whether that be majors or other sets of data.

from csv import DictReader

#In this section of code we are searching for whatever number correlates with dictionary MandMsheet1. When you input a number the dictionary searches for whatever number and the values that are paired with it. Even though we are searching an integer we pair the integer with a specific value in our dictionary. It searching for the string in the applicable rows and prints the data found in MandMsheet1.csv This is repeated for each input except for name and age
#searching for major in csv file
searching_for = (MandMsheet1[major])
with open('MandMsheet1.csv', 'r') as read_obj:
  
  csv_dict_reader = DictReader(read_obj)
  
  for row in csv_dict_reader:
    if row['Major'] == searching_for:
      print('\nMajor: ', row['Major'])
      print('\nRecommended Minors: ', row['Recommended Minors'])
      print('\nClubs and Organizations: ', row['Clubs and Organizations'])
      print('\nElectives: ', row['Electives'])

from csv import DictReader
#searching for gender in csv file
searching_for = (G_Scholarships[gender])
with open('G_Scholarships.csv', 'r') as read_obj:
  
  csv_dict_reader = DictReader(read_obj)

  for row in csv_dict_reader:
    if row['Gender'] == searching_for:
      print('\nGender: ', row['Gender'])
      print('\nScholarships: ', row['Scholarships_G'])

from csv import DictReader
#searching for first generation in csv file
searching_for = (Gen_Scholarships[first_gen])
with open('Gen_Scholarships.csv', 'r') as read_obj:
  
  csv_dict_reader = DictReader(read_obj)

  for row in csv_dict_reader:
    if row['First_Gen_Scholar'] == searching_for:
      print('\nFirst Generation? : ', row['First_Gen_Scholar'])
      print('\nScholarships: ', row['Scholarships_Gen'])

from csv import DictReader
#searching for race and ethnicity in csv file
searching_for = (R_E_Scholarships[race])
with open('R_E_Scholarships.csv', 'r') as read_obj:
  
  csv_dict_reader = DictReader(read_obj)

  for row in csv_dict_reader:
    if row['Race/Ethnicity'] == searching_for:
      print('\nRace: ', row['Race/Ethnicity'])
      print('\nScholarships: ', row['Scholarships_r/e'])

from csv import DictReader
#searching for sexuality in csv file
searching_for = (S_Scholarships[sexuality])
with open('S_Scholarships.csv', 'r') as read_obj:
  
  csv_dict_reader = DictReader(read_obj)

  for row in csv_dict_reader:
    if row['Sexuality'] == searching_for:
      print('\nSexuality: ', row['Sexuality'])
      print('\nScholarships: ', row['Scholarships_Sex'])